# coding: iso-8859-1

module RPG

  class CommonEvent
    def initialize
      @id = 0
      @name = ""
      @trigger = 0
      @switch_id = 1
      @list = [RPG::EventCommand.new]
    end
    attr_accessor :id
    attr_accessor :name
    attr_accessor :trigger
    attr_accessor :switch_id
    attr_accessor :list



    ###########################################
    # Ajouts aux classes
    ###########################################

    def to_dmk
      my = My_RPG::My_CommonEvent.new
      my.id = @id
      my.name = @name
      my.trigger = @trigger
      my.switch_id = @switch_id

      for i in 0...@list.size
        com_dmk = @list[i].to_dmk
        if com_dmk == nil
          #p @list[i]
          #getz
          next
        end
        com_dmk.page = my
        # On prcise l'indentation
        my.add_indent(com_dmk, @list[i].indent)
        my.list << com_dmk
      end


      # Rassemblement des instructions
      my.rassembler_instruction

      return my
    end



    def comparer(other)

      raise(DMKW_DMK_Diff.new("CommonEvent : id")) if @id != other.id
      raise(DMKW_DMK_Diff.new("CommonEvent : name")) if @name != other.name
      raise(DMKW_DMK_Diff.new("CommonEvent : trigger")) if @trigger != other.trigger
      raise(DMKW_DMK_Diff.new("CommonEvent : switch_id")) if @switch_id != other.switch_id



      # On compare toutes les instructions
      if @list.size != other.list.size
        #p @list.size, other.list.size
        #p @list, other.list
        raise(DMKW_DMK_Diff.new("CommonEvent : list size"))
      end
      for i in 0...@list.size
        raise(DMKW_DMK_Diff.new("CommonEvent : list")) if @list[i].comparer(other.list[i]) == false
      end


      return true
    end


    def inspect2
      txt = "#{self.class} id:#{@id} name:#{@name} trigger:#{@trigger} switch_id:#{@switch_id} \n"
      for com in @list
        txt << com.inspect2 << "\n"
      end
      return txt
    end

  end
end
